/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.buffer.Mappable;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL15;

public class MappedBuffer
extends VecBuffer
implements AutoCloseable {
    protected final long offset;
    protected final long length;
    protected final Mappable owner;

    public MappedBuffer(Mappable owner, ByteBuffer internal, long offset, long length) {
        this.internal = internal;
        this.owner = owner;
        this.offset = offset;
        this.length = length;
    }

    public void flush() {
        if (this.owner.isPersistent()) {
            return;
        }
        if (this.internal == null) {
            return;
        }
        GL15.glUnmapBuffer((int)this.owner.getType().glEnum);
        this.internal = null;
    }

    @Override
    public MappedBuffer position(int p) {
        if ((long)p < this.offset || (long)p >= this.offset + this.length) {
            throw new IndexOutOfBoundsException("Index " + p + " is not mapped");
        }
        super.position(p - (int)this.offset);
        return this;
    }

    @Override
    public void close() {
        this.flush();
    }
}

