/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.Instance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public abstract class AbstractInstance
implements Instance,
LightListener {
    protected final MaterialManager materialManager;
    public final Level world;
    protected boolean removed = false;

    public AbstractInstance(MaterialManager materialManager, Level world) {
        this.materialManager = materialManager;
        this.world = world;
    }

    public void init() {
    }

    public final void removeAndMark() {
        if (this.removed) {
            return;
        }
        this.remove();
        this.removed = true;
    }

    protected abstract void remove();

    public void update() {
    }

    public void updateLight() {
    }

    public boolean shouldReset() {
        return false;
    }

    @Override
    public boolean isListenerInvalid() {
        return this.removed;
    }

    @Override
    public void onLightUpdate(LightLayer type, ImmutableBox changed) {
        this.updateLight();
    }

    protected void relight(BlockPos pos, FlatLit<?> ... models) {
        this.relight(this.world.m_45517_(LightLayer.BLOCK, pos), this.world.m_45517_(LightLayer.SKY, pos), models);
    }

    protected <L extends FlatLit<?>> void relight(BlockPos pos, Stream<L> models) {
        this.relight(this.world.m_45517_(LightLayer.BLOCK, pos), this.world.m_45517_(LightLayer.SKY, pos), models);
    }

    protected void relight(int block, int sky, FlatLit<?> ... models) {
        this.relight(block, sky, Arrays.stream(models));
    }

    protected <L extends FlatLit<?>> void relight(int block, int sky, Stream<L> models) {
        models.forEach(model -> ((FlatLit)model.setBlockLight(block)).setSkyLight(sky));
    }
}

