/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.hardcoded;

import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.vertex.PosTexNormalWriterUnsafe;
import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class PartBuilder {
    private final float sizeU;
    private final float sizeV;
    private TextureAtlasSprite sprite;
    private final List<CuboidBuilder> cuboids = new ArrayList<CuboidBuilder>();
    private final String name;

    public PartBuilder(String name, int sizeU, int sizeV) {
        this.name = name;
        this.sizeU = sizeU;
        this.sizeV = sizeV;
    }

    public PartBuilder sprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public CuboidBuilder cuboid() {
        return new CuboidBuilder(this);
    }

    public ModelPart build() {
        return new ModelPart(this.cuboids, this.name);
    }

    private PartBuilder addCuboid(CuboidBuilder builder) {
        this.cuboids.add(builder);
        return this;
    }

    public static class CuboidBuilder {
        TextureAtlasSprite sprite;
        Set<Direction> visibleFaces = EnumSet.allOf(Direction.class);
        int textureOffsetU;
        int textureOffsetV;
        float posX1;
        float posY1;
        float posZ1;
        float posX2;
        float posY2;
        float posZ2;
        boolean invertYZ;
        boolean useRotation;
        float rotationX;
        float rotationY;
        float rotationZ;
        final PartBuilder partBuilder;

        CuboidBuilder(PartBuilder partBuilder) {
            this.partBuilder = partBuilder;
            this.sprite = partBuilder.sprite;
        }

        public CuboidBuilder textureOffset(int u, int v) {
            this.textureOffsetU = u;
            this.textureOffsetV = v;
            return this;
        }

        public CuboidBuilder start(float x, float y, float z) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            return this;
        }

        public CuboidBuilder end(float x, float y, float z) {
            this.posX2 = x;
            this.posY2 = y;
            this.posZ2 = z;
            return this;
        }

        public CuboidBuilder size(float x, float y, float z) {
            this.posX2 = this.posX1 + x;
            this.posY2 = this.posY1 + y;
            this.posZ2 = this.posZ1 + z;
            return this;
        }

        public CuboidBuilder shift(float x, float y, float z) {
            this.posX1 -= x;
            this.posY1 -= y;
            this.posZ1 -= z;
            this.posX2 -= x;
            this.posY2 -= y;
            this.posZ2 -= z;
            return this;
        }

        public CuboidBuilder rotate(float x, float y, float z) {
            this.useRotation = true;
            this.rotationX = x;
            this.rotationY = y;
            this.rotationZ = z;
            return this;
        }

        public CuboidBuilder rotateX(float x) {
            this.useRotation = true;
            this.rotationX = x;
            return this;
        }

        public CuboidBuilder rotateY(float y) {
            this.useRotation = true;
            this.rotationY = y;
            return this;
        }

        public CuboidBuilder rotateZ(float z) {
            this.useRotation = true;
            this.rotationZ = z;
            return this;
        }

        public CuboidBuilder sprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        public CuboidBuilder invertYZ() {
            this.invertYZ = true;
            return this;
        }

        public PartBuilder endCuboid() {
            return this.partBuilder.addCuboid(this);
        }

        public int vertices() {
            return this.visibleFaces.size() * 4;
        }

        public void buffer(PosTexNormalWriterUnsafe buffer) {
            float sizeX = this.posX2 - this.posX1;
            float sizeY = this.posY2 - this.posY1;
            float sizeZ = this.posZ2 - this.posZ1;
            float posX1 = this.posX1 / 16.0f;
            float posY1 = this.posY1 / 16.0f;
            float posZ1 = this.posZ1 / 16.0f;
            float posX2 = this.posX2 / 16.0f;
            float posY2 = this.posY2 / 16.0f;
            float posZ2 = this.posZ2 / 16.0f;
            Vector3f lll = new Vector3f(posX1, posY1, posZ1);
            Vector3f hll = new Vector3f(posX2, posY1, posZ1);
            Vector3f hhl = new Vector3f(posX2, posY2, posZ1);
            Vector3f lhl = new Vector3f(posX1, posY2, posZ1);
            Vector3f llh = new Vector3f(posX1, posY1, posZ2);
            Vector3f hlh = new Vector3f(posX2, posY1, posZ2);
            Vector3f hhh = new Vector3f(posX2, posY2, posZ2);
            Vector3f lhh = new Vector3f(posX1, posY2, posZ2);
            Vector3f down = Direction.DOWN.m_122432_();
            Vector3f up = Direction.UP.m_122432_();
            Vector3f west = Direction.WEST.m_122432_();
            Vector3f north = Direction.NORTH.m_122432_();
            Vector3f east = Direction.EAST.m_122432_();
            Vector3f south = Direction.SOUTH.m_122432_();
            if (this.useRotation) {
                Matrix3f matrix3f = new Matrix3f(new Quaternion(this.rotationX, this.rotationY, this.rotationZ, false));
                lll.m_122249_(matrix3f);
                hll.m_122249_(matrix3f);
                hhl.m_122249_(matrix3f);
                lhl.m_122249_(matrix3f);
                llh.m_122249_(matrix3f);
                hlh.m_122249_(matrix3f);
                hhh.m_122249_(matrix3f);
                lhh.m_122249_(matrix3f);
                down.m_122249_(matrix3f);
                up.m_122249_(matrix3f);
                west.m_122249_(matrix3f);
                north.m_122249_(matrix3f);
                east.m_122249_(matrix3f);
                south.m_122249_(matrix3f);
            }
            float f4 = this.getU(this.textureOffsetU);
            float f5 = this.getU((float)this.textureOffsetU + sizeZ);
            float f6 = this.getU((float)this.textureOffsetU + sizeZ + sizeX);
            float f7 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeX);
            float f8 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ);
            float f9 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ + sizeX);
            float f10 = this.getV(this.textureOffsetV);
            float f11 = this.getV((float)this.textureOffsetV + sizeZ);
            float f12 = this.getV((float)this.textureOffsetV + sizeZ + sizeY);
            if (this.invertYZ) {
                this.quad(buffer, new Vector3f[]{hlh, llh, lll, hll}, f6, f11, f7, f10, down);
                this.quad(buffer, new Vector3f[]{hhl, lhl, lhh, hhh}, f5, f10, f6, f11, up);
                this.quad(buffer, new Vector3f[]{lll, llh, lhh, lhl}, f5, f12, f4, f11, west);
                this.quad(buffer, new Vector3f[]{hll, lll, lhl, hhl}, f9, f12, f8, f11, north);
                this.quad(buffer, new Vector3f[]{hlh, hll, hhl, hhh}, f8, f12, f6, f11, east);
                this.quad(buffer, new Vector3f[]{llh, hlh, hhh, lhh}, f6, f12, f5, f11, south);
            } else {
                this.quad(buffer, new Vector3f[]{hlh, llh, lll, hll}, f5, f10, f6, f11, down);
                this.quad(buffer, new Vector3f[]{hhl, lhl, lhh, hhh}, f6, f11, f7, f10, up);
                this.quad(buffer, new Vector3f[]{lll, llh, lhh, lhl}, f4, f11, f5, f12, west);
                this.quad(buffer, new Vector3f[]{hll, lll, lhl, hhl}, f5, f11, f6, f12, north);
                this.quad(buffer, new Vector3f[]{hlh, hll, hhl, hhh}, f6, f11, f8, f12, east);
                this.quad(buffer, new Vector3f[]{llh, hlh, hhh, lhh}, f8, f11, f9, f12, south);
            }
        }

        public void quad(PosTexNormalWriterUnsafe buffer, Vector3f[] vertices, float minU, float minV, float maxU, float maxV, Vector3f normal) {
            buffer.putVertex(vertices[0].m_122239_(), vertices[0].m_122260_(), vertices[0].m_122269_(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_(), maxU, minV);
            buffer.putVertex(vertices[1].m_122239_(), vertices[1].m_122260_(), vertices[1].m_122269_(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_(), minU, minV);
            buffer.putVertex(vertices[2].m_122239_(), vertices[2].m_122260_(), vertices[2].m_122269_(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_(), minU, maxV);
            buffer.putVertex(vertices[3].m_122239_(), vertices[3].m_122260_(), vertices[3].m_122269_(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_(), maxU, maxV);
        }

        public float getU(float u) {
            if (this.sprite != null) {
                return this.sprite.m_118367_((double)(u * 16.0f / this.partBuilder.sizeU));
            }
            return u / this.partBuilder.sizeU;
        }

        public float getV(float v) {
            if (this.sprite != null) {
                return this.sprite.m_118393_((double)(v * 16.0f / this.partBuilder.sizeV));
            }
            return v / this.partBuilder.sizeV;
        }
    }
}

