/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.core.QuadConverter;
import java.nio.ByteBuffer;

public interface Model {
    public String name();

    public VertexList getReader();

    public int vertexCount();

    public VertexType getType();

    default public ElementBuffer createEBO() {
        return QuadConverter.getInstance().quads2Tris(this.vertexCount() / 4);
    }

    public void delete();

    default public int size() {
        return this.getType().byteOffset(this.vertexCount());
    }

    default public boolean empty() {
        return this.vertexCount() == 0;
    }

    default public void writeInto(ByteBuffer buffer) {
        this.getType().createWriter(buffer).writeVertexList(this.getReader());
    }
}

