/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import shadows.placebo.Placebo;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.PSerializerTypeAdapter;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class PSerializer<V>
implements JsonUtil.JsonDeserializer<V>,
JsonUtil.JsonSerializer<V>,
JsonUtil.NetDeserializer<V>,
JsonUtil.NetSerializer<V> {
    private final String name;
    private final JsonUtil.JsonDeserializer<V> jds;
    private final JsonUtil.JsonSerializer<V> js;
    private final JsonUtil.NetDeserializer<V> nds;
    private final JsonUtil.NetSerializer<V> ns;

    public PSerializer(String name, JsonUtil.JsonDeserializer<V> jds, JsonUtil.JsonSerializer<V> js, JsonUtil.NetDeserializer<V> nds, JsonUtil.NetSerializer<V> ns) {
        this.name = name;
        this.jds = jds;
        this.js = js;
        this.nds = nds;
        this.ns = ns;
    }

    @Override
    public JsonElement write(V src) {
        if (this.js == null) {
            throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to json, but this serializer does not support that operation.");
        }
        return this.js.write(src);
    }

    @Override
    public void write(V src, FriendlyByteBuf buf) {
        if (this.ns == null) {
            throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to the network, but this serializer does not support that operation.");
        }
        this.ns.write(src, buf);
    }

    @Override
    public V read(JsonElement json) throws JsonParseException {
        if (this.jds == null) {
            throw new UnsupportedOperationException("Attempted to deserialize a " + this.name + " from json, but this serializer does not support that operation.");
        }
        return this.jds.read(json);
    }

    @Override
    public V read(FriendlyByteBuf buf) {
        if (this.nds == null) {
            throw new UnsupportedOperationException("Attempted to deserialize a " + this.name + " from the network, but this serializer does not support that operation.");
        }
        return this.nds.read(buf);
    }

    private static <V> BiFunction<Object, Object, V> coerce(Method m) {
        MethodHandle k;
        try {
            k = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        return (p1, p2) -> {
            try {
                return p1 == null ? k.invoke(p2) : k.invoke(p1, p2);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Deprecated(forRemoval=true)
    public static <V> Builder<V> autoRegister(String name, Class<? extends V> clazz) {
        Builder<Object> builder = new Builder<Object>(name);
        Method[] methods = clazz.getDeclaredMethods();
        Class<?> jsonType = null;
        for (Method m : methods) {
            Class<?>[] p;
            if (Modifier.isStatic(m.getModifiers())) {
                if (!m.getName().equals("read") || (p = m.getParameterTypes()).length != 1) continue;
                if (p[0] == FriendlyByteBuf.class) {
                    builder.withNetworkDeserializer(buf -> PSerializer.coerce(m).apply(null, buf));
                    continue;
                }
                if (!JsonElement.class.isAssignableFrom(p[0])) continue;
                builder.withJsonDeserializer(obj -> PSerializer.coerce(m).apply(null, obj));
                if (jsonType == null) {
                    jsonType = p[0];
                    continue;
                }
                if (jsonType == p[0]) continue;
                throw new RuntimeException("Invalid automatic PSerializer registration - JSON read/write type mismatch!");
            }
            if (!m.getName().equals("write")) continue;
            p = m.getParameterTypes();
            if (p.length == 1) {
                if (p[0] != FriendlyByteBuf.class) continue;
                builder.withNetworkSerializer((inst, buf) -> PSerializer.coerce(m).apply(inst, buf));
                continue;
            }
            if (p.length != 0 || !JsonElement.class.isAssignableFrom(m.getReturnType())) continue;
            builder.withJsonSerializer(inst -> (JsonElement)PSerializer.coerce(m).apply(null, inst));
            if (jsonType == null) {
                jsonType = m.getReturnType();
                continue;
            }
            if (jsonType == m.getReturnType()) continue;
            throw new RuntimeException("Invalid automatic PSerializer registration - JSON read/write type mismatch!");
        }
        return builder;
    }

    public static <V> Builder<V> fromCodec(String name, Codec<? extends V> codec) {
        Builder<Object> builder = new Builder<Object>(name);
        Codec rawCodec = codec;
        Consumer<String> onErr = msg -> PSerializer.logCodecError(name, msg);
        builder.withJsonSerializer(obj -> (JsonElement)rawCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).getOrThrow(false, onErr));
        builder.withJsonDeserializer(json -> ((Pair)rawCodec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, onErr)).getFirst());
        builder.withNetworkSerializer((obj, buf) -> buf.m_130079_((CompoundTag)rawCodec.encodeStart((DynamicOps)NbtOps.f_128958_, obj).getOrThrow(false, onErr)));
        builder.withNetworkDeserializer(buf -> ((Pair)rawCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).getOrThrow(false, onErr)).getFirst());
        return builder;
    }

    private static void logCodecError(String name, String msg) {
        Placebo.LOGGER.error("Codec failure for type {}, message: {}", (Object)name, (Object)msg);
    }

    public static <V> Builder<V> builtin(String name, Supplier<V> factory) {
        Builder<Object> builder = new Builder<Object>(name);
        builder.withJsonDeserializer(json -> factory.get()).withJsonSerializer(o -> new JsonObject());
        builder.withNetworkDeserializer(net -> factory.get()).withNetworkSerializer((obj, buf) -> {});
        return builder;
    }

    public static <V extends PlaceboJsonReloadListener.TypeKeyed<V>> PSerializerTypeAdapter<V> makeTypeAdapter(BiMap<ResourceLocation, PSerializer<V>> serializers) {
        return new PSerializerTypeAdapter<V>(serializers);
    }

    public static class Builder<V> {
        private final String name;
        private JsonUtil.JsonDeserializer<V> jds;
        private JsonUtil.JsonSerializer<V> js;
        private JsonUtil.NetDeserializer<V> nds;
        private JsonUtil.NetSerializer<V> ns;

        public Builder(String name) {
            this.name = name;
        }

        public Builder<V> withJsonDeserializer(JsonUtil.JsonDeserializer<V> jds) {
            this.jds = jds;
            return this;
        }

        public Builder<V> withJsonSerializer(JsonUtil.JsonSerializer<V> js) {
            this.js = js;
            return this;
        }

        public Builder<V> withNetworkDeserializer(JsonUtil.NetDeserializer<V> nds) {
            this.nds = nds;
            return this;
        }

        public Builder<V> withNetworkSerializer(JsonUtil.NetSerializer<V> ns) {
            this.ns = ns;
            return this;
        }

        public Builder<V> json(JsonUtil.JsonDeserializer<V> jds, JsonUtil.JsonSerializer<V> js) {
            return this.withJsonDeserializer(jds).withJsonSerializer(js);
        }

        public Builder<V> net(JsonUtil.NetDeserializer<V> jds, JsonUtil.NetSerializer<V> js) {
            return this.withNetworkDeserializer(jds).withNetworkSerializer(js);
        }

        public PSerializer<V> build(boolean synced) {
            Preconditions.checkNotNull(this.jds, (Object)("Attempted to build a Serializer for " + this.name + " but no json deserializer was provided."));
            if (synced) {
                Preconditions.checkNotNull(this.nds, (Object)("Attempted to build a Synced Serializer for " + this.name + " but no network deserializer was provided."));
                Preconditions.checkNotNull(this.ns, (Object)("Attempted to build a Synced Serializer for " + this.name + " but no network serializer was provided."));
            }
            return new PSerializer<V>(this.name, this.jds, this.js, this.nds, this.ns);
        }
    }
}

