/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlackboardBlockTileRenderer
implements BlockEntityRenderer<BlackboardBlockTile> {
    public static final int WIDTH = 6;
    private final Minecraft mc = Minecraft.m_91087_();
    private final Camera camera;
    private final boolean noise;

    public BlackboardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.camera = this.mc.f_91063_.m_109153_();
        this.noise = MiscUtils.FESTIVITY.isAprilsFool() && PlatformHelper.getPlatform().isForge();
    }

    public int m_142163_() {
        return this.noise ? 64 : 8;
    }

    public boolean shouldRender(BlackboardBlockTile blockEntity, Vec3 cameraPos) {
        return super.m_142756_((BlockEntity)blockEntity, cameraPos);
    }

    public void render(BlackboardBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        LocalPlayer player;
        BlockHitResult blockHit;
        if (!CommonConfigs.Building.BLACKBOARD_MODE.get().canManualDraw() && !this.noise) {
            return;
        }
        Direction dir = tile.getDirection();
        float yaw = -dir.m_122435_();
        Vec3 cameraPos = this.camera.m_90583_();
        BlockPos pos = tile.m_58899_();
        if (this.noise) {
            int lu = combinedLightIn & 0xFFFF;
            int lv = combinedLightIn >> 16 & 0xFFFF;
            SuppPlatformStuff.getNoiseShader().m_173348_("Intensity").m_5985_(1.0f);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(RotHlpr.rot((Direction)dir));
            matrixStackIn.m_85845_(RotHlpr.XN90);
            matrixStackIn.m_85837_(-0.5, -0.5, -0.1865);
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.m_119194_(bufferSource, SuppPlatformStuff::staticNoise);
            VertexUtils.addQuadSide(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, ModMaterials.BLACKBOARD_OUTLINE.m_119204_());
            matrixStackIn.m_85849_();
            return;
        }
        if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)pos, (float)yaw, (float)0.0f, (Direction)dir, (float)0.375f)) {
            return;
        }
        HitResult hit = this.mc.f_91077_;
        if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).m_82425_().equals((Object)pos) && tile.getDirection() == blockHit.m_82434_() && (player = this.mc.f_91074_) != null && player.m_150110_().f_35938_ && BlackboardBlock.getStackChalkColor(player.m_21205_()) != null) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(RotHlpr.rot((Direction)dir));
            matrixStackIn.m_85845_(RotHlpr.XN90);
            matrixStackIn.m_85837_(-0.5, -0.5, -0.1875);
            int lu = combinedLightIn & 0xFFFF;
            int lv = combinedLightIn >> 16 & 0xFFFF;
            Vec2i pair = BlackboardBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)pair.x() * p;
            float y = (float)pair.y() * p;
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.m_119194_(bufferSource, RenderType::m_110452_);
            matrixStackIn.m_85837_((double)x, (double)(1.0f - y - p), 0.001);
            VertexUtils.addQuadSide(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, p, p, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, ModMaterials.BLACKBOARD_OUTLINE.m_119204_());
            matrixStackIn.m_85849_();
        }
    }
}

