/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.IContainerProvider;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SafeBlockTile
extends OpeneableContainerBlockEntity
implements IOwnerProtected {
    private String password = null;
    private String ownerName = null;
    private UUID owner = null;

    public SafeBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SAFE_TILE.get(), pos, state, 27);
    }

    public boolean canPlayerOpen(Player player, boolean feedbackMessage) {
        if (player == null || player.m_7500_()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.isNotOwnedBy(player)) {
                if (feedbackMessage) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                }
                return false;
            }
        } else {
            return KeyLockableTile.doesPlayerHaveKeyToOpen(player, this.password, feedbackMessage, "safe");
        }
        return true;
    }

    public boolean m_7525_(Player pPlayer) {
        return this.canPlayerOpen(pPlayer, false);
    }

    public String getPassword() {
        return this.password;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        if (this.f_58857_ != null) {
            Player p;
            if (owner != null && (p = this.f_58857_.m_46003_(owner)) != null) {
                this.ownerName = p.m_7755_().getString();
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void clearOwner() {
        this.ownerName = null;
        this.owner = null;
        this.password = null;
    }

    public Component m_5446_() {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.ownerName != null) {
                return Component.m_237110_((String)"gui.supplementaries.safe.name", (Object[])new Object[]{this.ownerName, super.m_5446_()});
            }
        } else if (this.password != null) {
            return Component.m_237110_((String)"gui.supplementaries.safe.password", (Object[])new Object[]{this.password, super.m_5446_()});
        }
        return super.m_5446_();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.safe");
    }

    @Override
    protected void playOpenSound(BlockState state) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)SafeBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.65f);
    }

    @Override
    protected void playCloseSound(BlockState state) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)SafeBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.65f);
    }

    @Override
    protected void updateBlockState(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128441_("Owner") ? tag.m_128342_("Owner") : null;
        if (tag.m_128441_("OwnerName")) {
            this.ownerName = tag.m_128461_("OwnerName");
        } else {
            this.owner = null;
        }
        this.password = tag.m_128441_("Password") ? tag.m_128461_("Password") : null;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveOwner(compound);
        if (this.ownerName != null) {
            compound.m_128359_("OwnerName", this.ownerName);
        }
        if (this.password != null) {
            compound.m_128359_("Password", this.password);
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return MiscUtils.isAllowedInShulker(stack);
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new SafeContainerMenu(id, player, (Container)this);
    }

    private static class SafeContainerMenu
    extends ShulkerBoxMenu
    implements IContainerProvider {
        private final Container container;

        public SafeContainerMenu(int id, Inventory inventory, Container container) {
            super(id, inventory, container);
            this.container = container;
        }

        @Override
        public Container getContainer() {
            return this.container;
        }
    }
}

