/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtils;
import com.ldtteam.structurize.client.BlueprintChunk;
import com.ldtteam.structurize.config.BlueprintRenderSettings;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.util.BlockUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintBlockAccess
extends Level {
    private static final Scoreboard SCOREBOARD = new Scoreboard();
    private Blueprint blueprint;
    private BlockPos worldPos;

    public BlueprintBlockAccess(Blueprint blueprint) {
        super((WritableLevelData)new BlueprintLevelData((LevelData)BlueprintBlockAccess.clientLevel().m_6106_()), BlueprintBlockAccess.clientLevel().m_46472_(), BlueprintBlockAccess.clientLevel().m_204156_(), () -> BlueprintBlockAccess.clientLevel().m_46473_(), true, false, 0L, 0);
        this.blueprint = blueprint;
    }

    private static ClientLevel clientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    private static Level anyLevel() {
        Minecraft mc = Minecraft.m_91087_();
        return SharedConstants.f_136183_ && mc.m_91091_() ? mc.m_91092_().m_6846_().m_11259_((UUID)mc.f_91074_.m_20148_()).f_19853_ : mc.f_91073_;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    public void setBlueprint(Blueprint blueprintIn) {
        this.blueprint = blueprintIn;
    }

    public void setWorldPos(BlockPos worldPos) {
        this.worldPos = worldPos;
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return BlueprintUtils.getTileEntityFromPos(this.blueprint, pos, this);
    }

    public BlockState m_8055_(BlockPos pos) {
        BlockState state = BlueprintUtils.getBlockInfoFromPos(this.blueprint, pos).getState();
        if (state.m_60734_() == ModBlocks.blockSolidSubstitution.get()) {
            return BlockUtils.getSubstitutionBlockAtWorld(BlueprintBlockAccess.anyLevel(), this.worldPos.m_121955_((Vec3i)pos), this.blueprint.getRawBlockStateFunction().compose(b -> b.m_121996_((Vec3i)this.worldPos)));
        }
        if (state.m_60734_() == ModBlocks.blockFluidSubstitution.get()) {
            return BlockUtils.getFluidForDimension(BlueprintBlockAccess.anyLevel());
        }
        if (state.m_60734_() == ModBlocks.blockSubstitution.get() && !BlueprintRenderSettings.instance.renderSettings.get("structurize.render.placeholders").booleanValue()) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_60734_() == ModBlocks.blockTagSubstitution.get()) {
            BlockEntityTagSubstitution tag;
            BlockEntity blockEntity = BlueprintUtils.getTileEntityFromPos(this.blueprint, pos, this);
            if (blockEntity instanceof BlockEntityTagSubstitution && !(tag = (BlockEntityTagSubstitution)blockEntity).getReplacement().isEmpty()) {
                return tag.getReplacement().getBlockState();
            }
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public ChunkAccess m_6522_(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return nonnull || this.m_7232_(x, z) ? new BlueprintChunk(this, x, z) : null;
    }

    public boolean m_7232_(int chunkX, int chunkZ) {
        int posX = SectionPos.m_123223_((int)chunkX);
        int posZ = SectionPos.m_123223_((int)chunkZ);
        return posX <= this.blueprint.getSizeX() && posZ <= this.blueprint.getSizeZ();
    }

    public int m_45517_(LightLayer lightType, BlockPos pos) {
        return RenderingCache.forceLightLevel() ? RenderingCache.getOurLightLevel() : BlueprintBlockAccess.clientLevel().m_45517_(lightType, this.worldPos.m_121955_((Vec3i)pos));
    }

    public int m_45524_(BlockPos pos, int amount) {
        return RenderingCache.forceLightLevel() ? RenderingCache.getOurLightLevel() : BlueprintBlockAccess.clientLevel().m_45524_(this.worldPos.m_121955_((Vec3i)pos), amount);
    }

    public float m_7717_(Direction p_104703_, boolean p_104704_) {
        boolean flag = BlueprintBlockAccess.clientLevel().m_104583_().m_108885_();
        if (!p_104704_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_104703_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return BlueprintBlockAccess.clientLevel().m_204166_(this.worldPos.m_121955_((Vec3i)pos));
    }

    public Scoreboard m_6188_() {
        return SCOREBOARD;
    }

    public FluidState m_6425_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.m_8055_(pos).m_60819_();
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public void m_46465_() {
    }

    protected void m_46466_() {
    }

    public void close() throws IOException {
    }

    public CrashReportCategory m_6026_(CrashReport report) {
        CrashReportCategory crashreportcategory = report.m_127514_("Structurize rendering engine");
        crashreportcategory.m_128165_("Blueprint", () -> this.blueprint.getName() + " of size: " + this.blueprint.getSizeX() + "|" + this.blueprint.getSizeY() + "|" + this.blueprint.getSizeZ());
        return crashreportcategory;
    }

    public boolean m_6933_(BlockPos p_241211_1_, BlockState p_241211_2_, int p_241211_3_, int p_241211_4_) {
        return false;
    }

    public boolean m_7740_(BlockPos p_241212_1_, boolean p_241212_2_, Entity p_241212_3_, int p_241212_4_) {
        return false;
    }

    public BiomeManager m_7062_() {
        return BlueprintBlockAccess.clientLevel().m_7062_();
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return null;
    }

    public List<Entity> m_6249_(Entity entityIn, AABB boundingBox, Predicate<? super Entity> predicate) {
        return null;
    }

    public Entity m_6815_(int id) {
        return null;
    }

    public int m_6924_(Heightmap.Types heightmapType, int x, int z) {
        return 0;
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
    }

    public int m_7354_() {
        return 0;
    }

    public String m_46464_() {
        return "Blueprint fake world for: " + this.blueprint.getName();
    }

    public float m_46722_(float delta) {
        return 0.0f;
    }

    public RecipeManager m_7465_() {
        return BlueprintBlockAccess.clientLevel().m_7465_();
    }

    public int m_7445_() {
        return RenderingCache.forceLightLevel() ? 0 : BlueprintBlockAccess.clientLevel().m_7445_();
    }

    public float m_46661_(float delta) {
        return 0.0f;
    }

    public boolean m_7966_(Player player, BlockPos pos) {
        return false;
    }

    public boolean m_46461_() {
        return !this.m_6042_().m_63967_() && this.m_7445_() < 4;
    }

    public boolean m_46471_() {
        return false;
    }

    public boolean m_46758_(BlockPos position) {
        return false;
    }

    public boolean m_7441_() {
        return true;
    }

    public void markAndNotifyBlock(BlockPos p_241211_1_, LevelChunk chunk, BlockState blockstate, BlockState p_241211_2_, int p_241211_3_, int p_241211_4_) {
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void m_46672_(BlockPos pos, Block blockIn) {
    }

    public boolean m_7471_(BlockPos pos, boolean isMoving) {
        return false;
    }

    public void m_46747_(BlockPos pos) {
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public void m_46703_(boolean hostile, boolean peaceful) {
    }

    public void m_46734_(float strength) {
    }

    public void m_46707_(float strength) {
    }

    public void m_46463_() {
    }

    public void m_46717_(BlockPos pos, Block blockIn) {
    }

    public boolean m_5450_(Entity entityIn, VoxelShape shape) {
        return true;
    }

    public List<VoxelShape> m_183134_(@Nullable Entity p_186447_, AABB p_186448_) {
        return Collections.emptyList();
    }

    public ChunkSource m_7726_() {
        return null;
    }

    @NotNull
    public RegistryAccess m_5962_() {
        return BlueprintBlockAccess.clientLevel().m_5962_();
    }

    public LevelTickAccess<Block> m_183326_() {
        return null;
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return null;
    }

    public void m_5898_(Player player, int type, BlockPos pos, int data) {
    }

    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return null;
    }

    public boolean m_45527_(BlockPos blockPosIn) {
        return true;
    }

    public void m_151525_(TickingBlockEntity p_151526_) {
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
    }

    public void m_151543_(BlockPos p_151544_) {
    }

    public Explosion m_7703_(Entity p_46526_, DamageSource p_46527_, ExplosionDamageCalculator p_46528_, double p_46529_, double p_46530_, double p_46531_, float p_46532_, boolean p_46533_, Explosion.BlockInteraction p_46534_) {
        return null;
    }

    public <T extends Entity> List<T> m_142425_(EntityTypeTest<Entity, T> p_151528_, AABB p_151529_, Predicate<? super T> p_151530_) {
        return null;
    }

    public int m_5736_() {
        return 0;
    }

    public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    public void m_151523_(BlockEntity p_151524_) {
    }

    public boolean m_183438_(long p_186456_) {
        return false;
    }

    public boolean m_183599_(Entity p_186458_) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
    }

    public void reviveCaps() {
    }

    public void m_186460_(BlockPos p_186461_, Block p_186462_, int p_186463_) {
    }

    public void m_186469_(BlockPos p_186470_, Fluid p_186471_, int p_186472_) {
    }

    public void m_186464_(BlockPos p_186465_, Block p_186466_, int p_186467_, TickPriority p_186468_) {
    }

    public void m_186473_(BlockPos p_186474_, Fluid p_186475_, int p_186476_, TickPriority p_186477_) {
    }

    public <T extends LivingEntity> List<T> m_45971_(Class<T> p_45972_, TargetingConditions p_45973_, LivingEntity p_45974_, AABB p_45975_) {
        return null;
    }

    public <T extends LivingEntity> T m_45963_(Class<? extends T> p_45964_, TargetingConditions p_45965_, LivingEntity p_45966_, double p_45967_, double p_45968_, double p_45969_, AABB p_45970_) {
        return null;
    }

    public int m_141928_() {
        return this.blueprint.getSizeY();
    }

    public int m_141937_() {
        return 0;
    }

    public BlockHitResult m_45547_(ClipContext p_45548_) {
        Vec3 vec3 = p_45548_.m_45702_().m_82546_(p_45548_.m_45693_());
        return BlockHitResult.m_82426_((Vec3)p_45548_.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)new BlockPos(p_45548_.m_45693_()));
    }

    public BlockHitResult m_151353_(ClipBlockStateContext p_151354_) {
        Vec3 vec3 = p_151354_.m_151405_().m_82546_(p_151354_.m_151404_());
        return BlockHitResult.m_82426_((Vec3)p_151354_.m_151404_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)new BlockPos(p_151354_.m_151404_()));
    }

    @Nullable
    public BlockEntity getExistingBlockEntity(BlockPos pos) {
        return this.m_7702_(pos);
    }

    public boolean m_186437_(Entity p_186438_, AABB p_186439_) {
        return false;
    }

    public Optional<Vec3> m_151418_(Entity p_151419_, VoxelShape p_151420_, Vec3 p_151421_, double p_151422_, double p_151423_, double p_151424_) {
        return Optional.empty();
    }

    public Iterable<VoxelShape> m_186434_(Entity p_186435_, AABB p_186436_) {
        return Collections.emptyList();
    }

    public Iterable<VoxelShape> m_186431_(Entity p_186432_, AABB p_186433_) {
        return Collections.emptyList();
    }

    public boolean m_45756_(Entity p_45757_, AABB p_45758_) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        return LazyOptional.empty();
    }

    public void m_214150_(Player p_220363_, double p_220364_, double p_220365_, double p_220366_, SoundEvent p_220367_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
    }

    public void m_213890_(Player p_220372_, Entity p_220373_, SoundEvent p_220374_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    private static class BlueprintLevelData
    implements WritableLevelData {
        private final LevelData vanillaLevelData;

        private BlueprintLevelData(LevelData vanillaLevelData) {
            this.vanillaLevelData = vanillaLevelData;
        }

        public int m_6789_() {
            return 0;
        }

        public int m_6527_() {
            return 0;
        }

        public int m_6526_() {
            return 0;
        }

        public float m_6790_() {
            return 0.0f;
        }

        public long m_6793_() {
            return this.vanillaLevelData.m_6793_();
        }

        public long m_6792_() {
            return RenderingCache.forceLightLevel() ? 6000L : BlueprintBlockAccess.clientLevel().m_46468_();
        }

        public boolean m_6534_() {
            return false;
        }

        public boolean m_6533_() {
            return false;
        }

        public void m_5565_(boolean p_78171_) {
        }

        public boolean m_5466_() {
            return false;
        }

        public GameRules m_5470_() {
            return this.vanillaLevelData.m_5470_();
        }

        public Difficulty m_5472_() {
            return Difficulty.EASY;
        }

        public boolean m_5474_() {
            return true;
        }

        public void m_6395_(int p_78651_) {
        }

        public void m_6397_(int p_78652_) {
        }

        public void m_6400_(int p_78653_) {
        }

        public void m_7113_(float p_78648_) {
        }
    }
}

