/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.update;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DomumOrnamentumUpdateHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Block GREEN_CACTUS_BLOCK = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:green_cactus_extra")));
    private static final Block CACTUS_BLOCK = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:cactus_extra")));
    private static final Block THIN_PAPER_BLOCK = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:white_paper_extra")));
    private static final Block PAPER_BLOCK = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:paper_extra")));
    private static final Block BLACK_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:black_brick_extra")));
    private static final Block BLUE_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:blue_brick_extra")));
    private static final Block BLUE_SLATE = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:blue_cobblestone_extra")));
    private static final Block BROWN_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:brown_brick_extra")));
    private static final Block CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:brick_extra")));
    private static final Block CYAN_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:cyan_brick_extra")));
    private static final Block GRAY_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:gray_brick_extra")));
    private static final Block GREEN_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:green_brick_extra")));
    private static final Block GREEN_SLATE = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:green_cobblestone_extra")));
    private static final Block LIGHT_BLUE_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:light_blue_brick_extra")));
    private static final Block LIGHT_GRAY_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:light_gray_brick_extra")));
    private static final Block LIME_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:lime_brick_extra")));
    private static final Block MAGENTA_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:magenta_brick_extra")));
    private static final Block ORANGE_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:orange_brick_extra")));
    private static final Block PINK_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:pink_brick_extra")));
    private static final Block PURPLE_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:purple_brick_extra")));
    private static final Block PURPLE_SLATE = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:purple_cobblestone_extra")));
    private static final Block RED_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:red_brick_extra")));
    private static final Block SLATE = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:cobblestone_extra")));
    private static final Block THATCHED = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:wheat_extra")));
    private static final Block WHITE_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:white_brick_extra")));
    private static final Block YELLOW_CLAY = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:yellow_brick_extra")));
    private static final Block MOSS_SLATE = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:mossy_cobblestone_extra")));
    private static final Map<String, Block> MATERIAL_TO_BLOCK_MAP = ImmutableMap.builder().put((Object)"cobble_stone", (Object)Blocks.f_50652_).put((Object)"oak", (Object)Blocks.f_50705_).put((Object)"spruce", (Object)Blocks.f_50741_).put((Object)"birch", (Object)Blocks.f_50742_).put((Object)"jungle", (Object)Blocks.f_50743_).put((Object)"acacia", (Object)Blocks.f_50744_).put((Object)"dark_oak", (Object)Blocks.f_50745_).put((Object)"warped", (Object)Blocks.f_50656_).put((Object)"crimson", (Object)Blocks.f_50655_).put((Object)"cactus", (Object)CACTUS_BLOCK).put((Object)"blockcactusplank", (Object)CACTUS_BLOCK).put((Object)"blockcactus", (Object)CACTUS_BLOCK).put((Object)"paper", (Object)PAPER_BLOCK).put((Object)"gilded_blackstone", (Object)Blocks.f_50706_).put((Object)"blackstone", (Object)Blocks.f_50730_).put((Object)"black_clay", (Object)BLACK_CLAY).put((Object)"blue_clay", (Object)BLUE_CLAY).put((Object)"blue_slate", (Object)BLUE_SLATE).put((Object)"brown_clay", (Object)BROWN_CLAY).put((Object)"cyan_clay", (Object)CYAN_CLAY).put((Object)"gray_clay", (Object)GRAY_CLAY).put((Object)"green_clay", (Object)GREEN_CLAY).put((Object)"green_slate", (Object)GREEN_SLATE).put((Object)"light_blue_clay", (Object)LIGHT_BLUE_CLAY).put((Object)"light_gray_clay", (Object)LIGHT_GRAY_CLAY).put((Object)"lime_clay", (Object)LIME_CLAY).put((Object)"magenta_clay", (Object)MAGENTA_CLAY).put((Object)"orange_clay", (Object)ORANGE_CLAY).put((Object)"pink_clay", (Object)PINK_CLAY).put((Object)"purple_clay", (Object)PURPLE_CLAY).put((Object)"purple_slate", (Object)PURPLE_SLATE).put((Object)"red_clay", (Object)RED_CLAY).put((Object)"thatched", (Object)THATCHED).put((Object)"white_clay", (Object)WHITE_CLAY).put((Object)"yellow_clay", (Object)YELLOW_CLAY).put((Object)"slate", (Object)SLATE).put((Object)"clay", (Object)CLAY).put((Object)"moss_slate", (Object)MOSS_SLATE).build();

    private DomumOrnamentumUpdateHandler() {
        throw new IllegalStateException("Can not instantiate an instance of: DomumOrnamentumUpdateHandler. This is a utility class");
    }

    public static void updateChunkTag(CompoundTag chunkTag, ChunkPos chunkPos) {
        CompoundTag levelTag = chunkTag.m_128469_("Level");
        ListTag sectionsTag = levelTag.m_128437_("Sections", 10);
        sectionsTag.forEach(sectionTag -> DomumOrnamentumUpdateHandler.updateSectionTag(levelTag, (CompoundTag)sectionTag, chunkPos));
    }

    private static void updateSectionTag(CompoundTag chunkTag, CompoundTag sectionTag, ChunkPos chunkPos) {
        if (!sectionTag.m_128441_("Palette") || !sectionTag.m_128441_("BlockStates")) {
            return;
        }
        ListTag paletteTag = sectionTag.m_128437_("Palette", 10);
        long[] blockStateIds = sectionTag.m_128467_("BlockStates");
        int bitCount = Math.max(4, Mth.m_14163_((int)paletteTag.size()));
        SimpleBitStorage bitStorage = new SimpleBitStorage(bitCount, 4096, blockStateIds);
        HashMultimap paletteEntryToBitStoragePositionMap = HashMultimap.create();
        for (int i = 0; i < 4096; ++i) {
            paletteEntryToBitStoragePositionMap.put((Object)bitStorage.m_13514_(i), (Object)i);
        }
        byte yOffset = sectionTag.m_128445_("Y");
        BlockPos chunkStart = new BlockPos(chunkPos.m_45604_(), (int)yOffset, chunkPos.m_45605_());
        ListTag blockEntityTags = chunkTag.m_128437_("TileEntities", 10);
        for (int i = 0; i < paletteTag.size(); ++i) {
            Optional<Tuple<BlockState, Optional<BlockEntity>>> replacementData;
            CompoundTag paletteEntryTag = paletteTag.m_128728_(i);
            if (!paletteEntryTag.m_128441_("Name")) continue;
            String name = paletteEntryTag.m_128461_("Name");
            if (!name.startsWith("%s:".formatted("structurize")) || (replacementData = DomumOrnamentumUpdateHandler.createBlockReplacementData(paletteEntryTag)).isEmpty()) continue;
            BlockState blockState = (BlockState)replacementData.get().m_14418_();
            CompoundTag blockStateTag = NbtUtils.m_129202_((BlockState)blockState);
            List paletteEntryTagKeys = paletteEntryTag.m_128431_().stream().toList();
            paletteEntryTagKeys.forEach(arg_0 -> ((CompoundTag)paletteEntryTag).m_128473_(arg_0));
            blockStateTag.m_128431_().forEach(key -> paletteEntryTag.m_128365_(key, Objects.requireNonNull(blockStateTag.m_128423_(key))));
            byte y = sectionTag.m_128445_("Y");
            if (!((Optional)replacementData.get().m_14419_()).isPresent()) continue;
            CompoundTag workingEntityNbt = ((BlockEntity)((Optional)replacementData.get().m_14419_()).get()).m_187480_();
            paletteEntryToBitStoragePositionMap.get((Object)i).forEach(bitStorageIndex -> {
                int inChunkX = bitStorageIndex & 0xF;
                int inChunkY = bitStorageIndex >> 8 & 0xF;
                int inChunkZ = bitStorageIndex >> 4 & 0xF;
                BlockPos targetPos = chunkStart.m_7918_(inChunkX, y * 15 + inChunkY, inChunkZ);
                CompoundTag targetTag = workingEntityNbt.m_6426_();
                targetTag.m_128405_("x", targetPos.m_123341_());
                targetTag.m_128405_("y", targetPos.m_123342_());
                targetTag.m_128405_("z", targetPos.m_123343_());
                blockEntityTags.add((Object)targetTag);
            });
        }
    }

    public static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockReplacementData(CompoundTag paletteEntryTag) {
        String name = paletteEntryTag.m_128461_("Name");
        if (name.endsWith("_blockpaperwall")) {
            return DomumOrnamentumUpdateHandler.createBlockpaperWallReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("stair") || name.endsWith("stairs")) {
            return DomumOrnamentumUpdateHandler.createBlockStairReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("_wall")) {
            return DomumOrnamentumUpdateHandler.createBlockWallReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("shingle_slab")) {
            return DomumOrnamentumUpdateHandler.createBlockShingeSlabReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("shingle")) {
            return DomumOrnamentumUpdateHandler.createBlockShingleReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("slab")) {
            return DomumOrnamentumUpdateHandler.createBlockSlabReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("fencegate")) {
            return DomumOrnamentumUpdateHandler.createBlockFenceGateReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("fence")) {
            return DomumOrnamentumUpdateHandler.createBlockFenceReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("trapdoor")) {
            return DomumOrnamentumUpdateHandler.createBlockTrapDoorReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("door")) {
            return DomumOrnamentumUpdateHandler.createBlockDoorReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("carpet")) {
            return DomumOrnamentumUpdateHandler.createBlockDirectReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        if (name.endsWith("timber_frame")) {
            return DomumOrnamentumUpdateHandler.createBlockTimberFrameReplacementData(name, paletteEntryTag.m_128469_("Properties"));
        }
        return DomumOrnamentumUpdateHandler.createBlockDirectReplacementData(name, paletteEntryTag.m_128469_("Properties"));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockTimberFrameReplacementData(String blockName, CompoundTag propertiesTag) {
        String mat1;
        Block timberFrameBlock;
        String materialName = blockName.replace("structurize:", "").replace("_timber_frame", "");
        if (materialName.contains("double_crossed")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:double_crossed"));
        } else if (materialName.contains("down_gated")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:down_gated"));
        } else if (materialName.contains("horizontal_plain")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:horizontal_plain"));
        } else if (materialName.contains("one_crossed_lr")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:one_crossed_lr"));
        } else if (materialName.contains("one_crossed_rl")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:one_crossed_rl"));
        } else if (materialName.contains("plain")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:plain"));
        } else if (materialName.contains("side_framed_horizontal")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:side_framed_horizontal"));
        } else if (materialName.contains("up_gated")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:up_gated"));
        } else if (materialName.contains("side_framed")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:side_framed"));
        } else if (materialName.contains("framed")) {
            timberFrameBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum:framed"));
        } else {
            LOGGER.error("Could not find replacement block for material: %s to create a new timberframe. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        if (timberFrameBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new timberframe. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        String remainingName = materialName.replace(ForgeRegistries.BLOCKS.getKey((Object)timberFrameBlock).m_135815_() + "_", "");
        String[] split = remainingName.split("_");
        int startIndex2 = 1;
        if (remainingName.contains("dark_oak")) {
            startIndex2 = 2;
            mat1 = "dark_oak";
        } else {
            mat1 = split[0];
        }
        Block block1 = MATERIAL_TO_BLOCK_MAP.getOrDefault(mat1.toLowerCase(Locale.ROOT), Blocks.f_50016_);
        if (block1 == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new timberframe. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Object mat2 = "";
        for (int i = startIndex2; i < split.length; ++i) {
            mat2 = (String)mat2 + split[i] + "_";
        }
        Block block2 = MATERIAL_TO_BLOCK_MAP.getOrDefault(((String)(mat2 = ((String)mat2).substring(0, ((String)mat2).length() - 1))).toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", (String)mat2))));
        if (block2 == Blocks.f_50016_ && (block2 = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", (String)mat2 + "s")))) == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new timberframe. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        IMateriallyTexturedBlock mtTFBlock = (IMateriallyTexturedBlock)timberFrameBlock;
        EntityBlock ebTFBlock = (EntityBlock)timberFrameBlock;
        BlockEntity tfBlockEntity = Objects.requireNonNull(ebTFBlock.m_142194_(BlockPos.f_121853_, timberFrameBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtTFBlockEntity = (IMateriallyTexturedBlockEntity)tfBlockEntity;
        Collection components = mtTFBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)frameComponent.getId(), (Object)block1).put((Object)centerComponent.getId(), (Object)block2).build());
        mtTFBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(timberFrameBlock, propertiesTag), Optional.of(tfBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockShingleReplacementData(String blockName, CompoundTag propertiesTag) {
        String mat1;
        String materialName = blockName.replace("structurize:", "").replace("_shingle", "");
        String[] split = materialName.split("_");
        int endIndex = split.length - 1;
        if (materialName.contains("dark_oak")) {
            endIndex = split.length - 2;
            mat1 = "dark_oak";
        } else {
            mat1 = split[endIndex];
        }
        Block block1 = MATERIAL_TO_BLOCK_MAP.getOrDefault(mat1.toLowerCase(Locale.ROOT), Blocks.f_50016_);
        if (block1 == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new shingle. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Object mat2 = "";
        for (int i = 0; i < endIndex; ++i) {
            mat2 = (String)mat2 + split[i] + "_";
        }
        Block block2 = MATERIAL_TO_BLOCK_MAP.getOrDefault(((String)(mat2 = ((String)mat2).substring(0, ((String)mat2).length() - 1))).toLowerCase(Locale.ROOT), Blocks.f_50016_);
        if (block2 == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new shingle. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block shingleBlock = IModBlocks.getInstance().getShingle();
        IMateriallyTexturedBlock mtShingleBlock = (IMateriallyTexturedBlock)shingleBlock;
        EntityBlock ebShingleBlock = (EntityBlock)shingleBlock;
        BlockEntity shingleEntity = Objects.requireNonNull(ebShingleBlock.m_142194_(BlockPos.f_121853_, shingleBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtShingleSlabBlockEntity = (IMateriallyTexturedBlockEntity)shingleEntity;
        Collection components = mtShingleBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent roofComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent supportComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)roofComponent.getId(), (Object)block2).put((Object)supportComponent.getId(), (Object)block1).build());
        mtShingleSlabBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(shingleBlock, propertiesTag), Optional.of(shingleEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockShingeSlabReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_shingle_slab", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Blocks.f_50016_);
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new shingle slab. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block shingleSlabBlock = IModBlocks.getInstance().getShingleSlab();
        IMateriallyTexturedBlock mtShingleSlabBlock = (IMateriallyTexturedBlock)shingleSlabBlock;
        EntityBlock ebShingleSlablBlock = (EntityBlock)shingleSlabBlock;
        BlockEntity thinShingleSlabEntity = Objects.requireNonNull(ebShingleSlablBlock.m_142194_(BlockPos.f_121853_, shingleSlabBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtShingleSlabBlockEntity = (IMateriallyTexturedBlockEntity)thinShingleSlabEntity;
        Collection components = mtShingleSlabBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent roofComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent supportComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)roofComponent.getId(), (Object)replacementBlock).put((Object)supportComponent.getId(), (Object)Blocks.f_50705_).put((Object)coverComponent.getId(), (Object)replacementBlock).build());
        mtShingleSlabBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(shingleSlabBlock, propertiesTag), Optional.of(thinShingleSlabEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockpaperWallReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_blockpaperwall", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Blocks.f_50016_);
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new paper wall. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block thinWallBlock = IModBlocks.getInstance().getPaperWall();
        IMateriallyTexturedBlock mtThinWallBlock = (IMateriallyTexturedBlock)thinWallBlock;
        EntityBlock ebThinWallBlock = (EntityBlock)thinWallBlock;
        BlockEntity thinWallBlockEntity = Objects.requireNonNull(ebThinWallBlock.m_142194_(BlockPos.f_121853_, thinWallBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtThinWallBlockEntity = (IMateriallyTexturedBlockEntity)thinWallBlockEntity;
        Collection components = mtThinWallBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)frameComponent.getId(), (Object)replacementBlock).put((Object)centerComponent.getId(), (Object)THIN_PAPER_BLOCK).build());
        mtThinWallBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(thinWallBlock, propertiesTag), Optional.of(thinWallBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockStairReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_stairs", "").replace("stair", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new stair. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block stairBlock = IModBlocks.getInstance().getStair();
        IMateriallyTexturedBlock mtStairBlock = (IMateriallyTexturedBlock)stairBlock;
        EntityBlock ebStairBlock = (EntityBlock)stairBlock;
        BlockEntity stairBlockEntity = Objects.requireNonNull(ebStairBlock.m_142194_(BlockPos.f_121853_, stairBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtStairBlockEntity = (IMateriallyTexturedBlockEntity)stairBlockEntity;
        Collection components = mtStairBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtStairBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(stairBlock, propertiesTag), Optional.of(stairBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockWallReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_wall", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new wall. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block wallBlock = IModBlocks.getInstance().getWall();
        IMateriallyTexturedBlock mtWallBlock = (IMateriallyTexturedBlock)wallBlock;
        EntityBlock ebWallBlock = (EntityBlock)wallBlock;
        BlockEntity wallBlockEntity = Objects.requireNonNull(ebWallBlock.m_142194_(BlockPos.f_121853_, wallBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtWallBlockEntity = (IMateriallyTexturedBlockEntity)wallBlockEntity;
        Collection components = mtWallBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtWallBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(wallBlock, propertiesTag), Optional.of(wallBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockSlabReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_slab", "").replace("slab", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new slab. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block slabBlock = IModBlocks.getInstance().getSlab();
        IMateriallyTexturedBlock mtSlabBlock = (IMateriallyTexturedBlock)slabBlock;
        EntityBlock ebSlabBlock = (EntityBlock)slabBlock;
        BlockEntity slabBlockEntity = Objects.requireNonNull(ebSlabBlock.m_142194_(BlockPos.f_121853_, slabBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtSlabBlockEntity = (IMateriallyTexturedBlockEntity)slabBlockEntity;
        Collection components = mtSlabBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtSlabBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(slabBlock, propertiesTag), Optional.of(slabBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockFenceReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_fence", "").replace("fence", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new fence. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block fenceBlock = IModBlocks.getInstance().getFence();
        IMateriallyTexturedBlock mtFenceBlock = (IMateriallyTexturedBlock)fenceBlock;
        EntityBlock ebFenceBlock = (EntityBlock)fenceBlock;
        BlockEntity fenceBlockEntity = Objects.requireNonNull(ebFenceBlock.m_142194_(BlockPos.f_121853_, fenceBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtFenceBlockEntity = (IMateriallyTexturedBlockEntity)fenceBlockEntity;
        Collection components = mtFenceBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtFenceBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(fenceBlock, propertiesTag), Optional.of(fenceBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockFenceGateReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_fencegate", "").replace("fencegate", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new gate. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block fenceGateBlock = IModBlocks.getInstance().getFenceGate();
        IMateriallyTexturedBlock mtFenceGateBlock = (IMateriallyTexturedBlock)fenceGateBlock;
        EntityBlock ebFenceGateBlock = (EntityBlock)fenceGateBlock;
        BlockEntity fenceGateBlockEntity = Objects.requireNonNull(ebFenceGateBlock.m_142194_(BlockPos.f_121853_, fenceGateBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtFenceGateBlockEntity = (IMateriallyTexturedBlockEntity)fenceGateBlockEntity;
        Collection components = mtFenceGateBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtFenceGateBlockEntity.updateTextureDataWith(textureData);
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(fenceGateBlock, propertiesTag), Optional.of(fenceGateBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockDoorReplacementData(String blockName, CompoundTag propertiesTag) {
        Block doorBlock = IModBlocks.getInstance().getFancyDoor();
        IMateriallyTexturedBlock mtDoorBlock = (IMateriallyTexturedBlock)doorBlock;
        EntityBlock ebDoorBlock = (EntityBlock)doorBlock;
        BlockEntity doorBlockEntity = Objects.requireNonNull(ebDoorBlock.m_142194_(BlockPos.f_121853_, doorBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtDoorBlockEntity = (IMateriallyTexturedBlockEntity)doorBlockEntity;
        Collection components = mtDoorBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        IMateriallyTexturedBlockComponent secondComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)CACTUS_BLOCK).put((Object)secondComponent.getId(), (Object)GREEN_CACTUS_BLOCK).build());
        mtDoorBlockEntity.updateTextureDataWith(textureData);
        propertiesTag.m_128359_("type", "creeper");
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(doorBlock, propertiesTag), Optional.of(doorBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockTrapDoorReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "").replace("_trapdoor", "").replace("trapdoor", "");
        Block replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName))));
        if (replacementBlock == Blocks.f_50016_) {
            replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName + "s"))));
        }
        if (replacementBlock == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new trapdoor. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        Block trapDoorBlock = IModBlocks.getInstance().getTrapdoor();
        IMateriallyTexturedBlock mtTrapDoorBlock = (IMateriallyTexturedBlock)trapDoorBlock;
        EntityBlock ebTrapDoorBlock = (EntityBlock)trapDoorBlock;
        BlockEntity trapDoorBlockEntity = Objects.requireNonNull(ebTrapDoorBlock.m_142194_(BlockPos.f_121853_, trapDoorBlock.m_49966_()));
        IMateriallyTexturedBlockEntity mtTrapDoorBlockEntity = (IMateriallyTexturedBlockEntity)trapDoorBlockEntity;
        Collection components = mtTrapDoorBlock.getComponents();
        Iterator componentIterator = components.iterator();
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)componentIterator.next();
        MaterialTextureData textureData = new MaterialTextureData((Map)ImmutableMap.builder().put((Object)mainComponent.getId(), (Object)replacementBlock).build());
        mtTrapDoorBlockEntity.updateTextureDataWith(textureData);
        propertiesTag.m_128359_("type", "port_manteau");
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(trapDoorBlock, propertiesTag), Optional.of(trapDoorBlockEntity)));
    }

    private static Optional<Tuple<BlockState, Optional<BlockEntity>>> createBlockDirectReplacementData(String blockName, CompoundTag propertiesTag) {
        String materialName = blockName.replace("structurize:", "");
        Block replacementBlock = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("domum_ornamentum", materialName)));
        if (replacementBlock == Blocks.f_50016_ && (replacementBlock = MATERIAL_TO_BLOCK_MAP.getOrDefault(materialName.toLowerCase(Locale.ROOT), Blocks.f_50016_)) == Blocks.f_50016_) {
            LOGGER.error("Could not find replacement block for material: %s to create a new direct block. Conversion is skipped.".formatted(materialName));
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)DomumOrnamentumUpdateHandler.buildBlockState(replacementBlock, propertiesTag), Optional.empty()));
    }

    private static BlockState buildBlockState(Block block, CompoundTag propertiesTag) {
        BlockState workingState = block.m_49966_();
        if (propertiesTag == null) {
            return workingState;
        }
        StateDefinition statedefinition = block.m_49965_();
        for (String s : propertiesTag.m_128431_()) {
            Property property = statedefinition.m_61081_(s);
            if (property == null) continue;
            workingState = DomumOrnamentumUpdateHandler.setBlockStatePropertyValueFromString(workingState, property, s, propertiesTag);
        }
        return workingState;
    }

    private static <T extends Comparable<T>> BlockState setBlockStatePropertyValueFromString(BlockState blockState, Property<T> property, String propertyName, CompoundTag propertiesTag) {
        Optional optional = property.m_6215_(propertiesTag.m_128461_(propertyName));
        if (optional.isPresent()) {
            return (BlockState)blockState.m_61124_(property, (Comparable)optional.get());
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)propertyName, (Object)propertiesTag.m_128461_(propertyName), (Object)propertiesTag.toString());
        return blockState;
    }
}

